IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_GERA_PENDENCIA_SNGPC]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_EST_PROD_GERA_PENDENCIA_SNGPC]
GO

CREATE PROCEDURE P_EST_PROD_GERA_PENDENCIA_SNGPC 
AS

	DELETE
		A
	FROM 
		EST_NF_ENT_IT_EST_SNGPC_PENDENTE A
		INNER JOIN EST_SNGPC_ATUALIZACAO B ON
		A.CD_EMP      = B.CD_EMP
		AND A.CD_PROD = B.CD_PROD
	WHERE
		B.FLAG_CONTROLADO = 0
		AND B.FLAG_PROCESSADO = 0

 -- Remove as pendncias de sada dos produtos no controlados
	DELETE
		A
	FROM 
		EST_NF_SAI_IT_EST_SNGPC_PENDENTE A
		INNER JOIN EST_SNGPC_ATUALIZACAO B ON
		A.CD_EMP      = B.CD_EMP
		AND A.CD_PROD = B.CD_PROD
	WHERE
		B.FLAG_CONTROLADO = 0
		AND B.FLAG_PROCESSADO = 0

	-- Remove as pendncias de vendas dos produtos no controlados
	DELETE
	A
	FROM 
		PDV_VD_IT_EST_SNGPC_PENDENTE A
		INNER JOIN PDV_VD_IT B ON
		A.CD_EMP = B.CD_EMP
		AND A.CD_FILIAL = B.CD_FILIAL
		AND A.CD_VD = B.CD_VD
		AND A.CD_IT = B.CD_IT
		INNER JOIN EST_SNGPC_ATUALIZACAO C ON
		B.CD_EMP      = C.CD_EMP
		AND B.CD_PROD = C.CD_PROD
	WHERE
		C.FLAG_CONTROLADO = 0
		AND C.FLAG_PROCESSADO = 0



	 -- Insere as pendncias de entrada dos produtos controlados dos ltimos 30 dias
	INSERT INTO EST_NF_ENT_IT_EST_SNGPC_PENDENTE (CD_EMP,CD_FILIAL,CD_NF,CD_PROD,DT_CAD)
	SELECT
		A.CD_EMP
		, A.CD_FILIAL
		, A.CD_NF
		, A.CD_PROD
		, GETDATE()
	FROM
		V_EST_NF_ENT_IT A
		INNER JOIN EST_SNGPC_ATUALIZACAO B ON
		A.CD_EMP      = B.CD_EMP
		AND A.CD_PROD = B.CD_PROD
   
		--Exclui Nota fiscal complementar
		INNER JOIN GLB_MOV_OP O ON 
		a.CD_NT_MOV = O.CD_MOV_OP
		AND ISNULL(	O.FLAG_MOV_OP_NFE_CPL,0)=0

		LEFT JOIN EST_NF_ENT_IT_EST_SNGPC_PENDENTE AS C ON
		A.CD_EMP        = C.CD_EMP
		AND A.CD_FILIAL = C.CD_FILIAL
		AND A.CD_NF     = C.CD_NF
		AND A.CD_PROD   = C.CD_PROD
		LEFT JOIN EST_SNGPC_ENTRADA AS D ON
		A.CD_EMP        = D.CD_EMP
		AND A.CD_FILIAL = D.CD_FILIAL
		AND A.CD_NF     = D.CD_NF
		AND A.CD_PROD   = D.CD_PROD
	WHERE
		B.FLAG_CONTROLADO = 1
		AND B.FLAG_PROCESSADO = 0
		AND A.DT_ENT >= DATEADD(DAY, - 30, GETDATE())
		AND C.CD_EMP IS NULL
		AND D.CD_EMP IS NULL

	-- Insere as pendncias de sada dos produtos controlados dos ltimos 30 dias
	 INSERT INTO EST_NF_SAI_IT_EST_SNGPC_PENDENTE (CD_EMP,CD_FILIAL,CD_NF,CD_PROD,CD_IT,DT_CAD)
	 SELECT
		  A.CD_EMP
		  , A.CD_FILIAL
		  , A.CD_NF
		  , A.CD_PROD
		  , A.CD_IT
		  , GETDATE()
	 FROM
		EST_NF_SAI_IT A
		INNER JOIN EST_NF_SAI B ON
		A.CD_EMP        = B.CD_EMP
		AND A.CD_FILIAL = B.CD_FILIAL
		AND A.CD_NF     = B.CD_NF

		--Exclui Nota fiscal complementar
		INNER JOIN GLB_MOV_OP O ON 
		B.CD_NT_MOV = O.CD_MOV_OP
		AND ISNULL(	O.FLAG_MOV_OP_NFE_CPL,0)=0

		INNER JOIN EST_SNGPC_ATUALIZACAO C ON
		A.CD_EMP      = C.CD_EMP
		AND A.CD_PROD = C.CD_PROD
		LEFT JOIN EST_NF_SAI_IT_EST_SNGPC_PENDENTE AS D ON
		A.CD_EMP        = D.CD_EMP
		AND A.CD_FILIAL = D.CD_FILIAL
		AND A.CD_NF     = D.CD_NF
		AND A.CD_PROD   = D.CD_PROD
		AND A.CD_IT     = D.CD_IT
		LEFT JOIN EST_NF_SAI_IT_EST_SNGPC_SAIDA AS E ON
		A.CD_EMP        = E.CD_EMP
		AND A.CD_FILIAL = E.CD_FILIAL
		AND A.CD_NF     = E.CD_NF
		AND A.CD_PROD   = E.CD_PROD
		AND A.CD_IT     = E.CD_IT
	 WHERE
		C.FLAG_CONTROLADO = 1
		AND C.FLAG_PROCESSADO = 0
		AND B.DT_EMI_NF >= DATEADD(DAY, - 30, GETDATE())
		AND D.CD_EMP IS NULL
		AND E.CD_EMP IS NULL

	-- Insere as pendncias de venda dos produtos controlados dos ltimos 30 dias
	INSERT INTO PDV_VD_IT_EST_SNGPC_PENDENTE (CD_EMP,CD_FILIAL,CD_VD,CD_IT,DT_CAD)
	SELECT
		A.CD_EMP
		, A.CD_FILIAL
		, A.CD_VD
		, A.CD_IT
		, GETDATE()
	FROM
		V_PDV_VD_IT A
		INNER JOIN EST_SNGPC_ATUALIZACAO B ON
		A.CD_EMP      = B.CD_EMP
		AND A.CD_PROD = B.CD_PROD
		LEFT JOIN PDV_VD_IT_EST_SNGPC_PENDENTE AS C ON
		A.CD_EMP        = C.CD_EMP
		AND A.CD_FILIAL = C.CD_FILIAL
		AND A.CD_VD     = C.CD_VD
		AND A.CD_IT     = C.CD_IT
		LEFT JOIN PDV_VD_IT_EST_SNGPC_SAIDA AS D ON
		A.CD_EMP        = D.CD_EMP
		AND A.CD_FILIAL = D.CD_FILIAL
		AND A.CD_VD     = D.CD_VD
		AND A.CD_IT     = D.CD_IT
	WHERE
		B.FLAG_CONTROLADO = 1
		AND B.FLAG_PROCESSADO = 0
		AND A.DT_VD >= DATEADD(DAY, - 30, GETDATE())
		AND C.CD_EMP IS NULL
		AND D.CD_EMP IS NULL 

-- Atualiza os registros processados
UPDATE EST_SNGPC_ATUALIZACAO SET FLAG_PROCESSADO = 1;